{
  Important: Methods and properties of objects in visual components can only be
  used in a method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure MWatek.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end;
}
unit UWatek;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

const cMAX  = 10;
const cWAIT = 1000;

type

MWatek = class(TThread)
private
   Memo    : TMemo;	// tylko wskanik, nie usuwa
   wykonuj : Boolean;
   cyfra   : Integer;

protected
   procedure   Execute; override;

public
   procedure   Display();
   procedure   Counter();   
   constructor Create(CreateSuspended: Boolean; parMemo: TMemo);
end;

implementation
{------------------------------------------------------------------------------}
procedure MWatek.Counter();
begin
	Inc(cyfra);
end;

constructor MWatek.Create(CreateSuspended: Boolean; parMemo: TMemo);
begin
	inherited Create(CreateSuspended);
   
   Memo    := parMemo;
   wykonuj := true;
   cyfra   := 0;

   FreeOnTerminate := true;
end;

procedure MWatek.Display();
begin
   Memo.Lines.Add(IntToStr(cyfra));
end;

procedure MWatek.Execute();
begin
   while wykonuj do
   begin
      Counter();
      Synchronize(Display);

      if (Terminated and (cyfra >= cMAX)) then
      begin
         wykonuj := false;
      end;

      Sleep(cWAIT);
   end;

   Synchronize(Display);
end;

end.

